unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

const cILOSC = 50;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    imgKONIEC: TImage;
    imgZBUDUJ: TImage;
    imgUSUN: TImage;
    Panel2: TPanel;
    Panel3: TPanel;
    sb1: TScrollBox;
    img1: TImage;
    sb2: TScrollBox;
    procedure imgUSUNClick(Sender: TObject);
    procedure imgZBUDUJClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);
  private

  public
	 procedure Koniec();
	 procedure Make_elements();
	 procedure Delete_elements();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.imgUSUNClick(Sender: TObject);
begin
	Delete_elements();
end;

procedure TMainForm.imgZBUDUJClick(Sender: TObject);
begin
	Make_elements();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
	fn   : String;
   szer : Integer;
   wys  : Integer;

begin
	fn   := ExtractFilePath(Application.ExeName) + 'trawa.bmp';
	szer := sb1.Width;
	wys  := sb1.Height;

   img1.Width  := szer + 10;
   img1.Height := wys  + 10;

	if FileExists(fn) then
   begin
   	img1.Picture.LoadFromFile(fn);
   	img1.Stretch := true;
   end;
end;

procedure TMainForm.Make_elements();
var
	lbl   : TLabel;
   edit  : TEdit;
	txt   : String;
	lp    : Integer;
   wspy  : Integer;

begin
	lbl  := Nil;
   edit := Nil;
	txt  := '';
	lp   := 0;
	wspy := 0;

   for lp := 0 to cILOSC do
   begin
		wspy := wspy + 50;

		lbl          := TLabel.Create(sb2);
      lbl.Parent   := sb2;
      lbl.Top      := wspy;
      lbl.Left     := 10;
		txt          := 'Label ' + IntToStr(lp+1);
      lbl.Caption  := txt;
		txt          := 'Label' + IntToStr(lp+1);
      lbl.Name     := txt;

      edit         := TEdit.Create(sb2);
      edit.Parent  := sb2;
      edit.Top     := wspy;
      edit.Left    := 100;
      edit.Width   := 220;
		txt          := 'Edit ' + IntToStr(lp+1);
      edit.Text    := txt;
		txt          := 'Edit' + IntToStr(lp+1);
      edit.Name    := txt;
   end;
end;

procedure TMainForm.Delete_elements();
var
	wsk  : TComponent;
	txt  : String;
	lp   : Integer;

begin
	wsk  := Nil;
	txt  := '';
	lp   := 0;

   for lp := 0 to cILOSC do
   begin
		txt := 'Label' + IntToStr(lp+1);

      wsk := sb2.FindComponent(txt);

      if wsk <> Nil then
      begin
      	FreeAndNil(wsk);
      end;
   end;

   for lp := 0 to cILOSC do
   begin
		txt := 'Edit' + IntToStr(lp+1);

      wsk := sb2.FindComponent(txt);

      if wsk <> Nil then
      begin
      	FreeAndNil(wsk);
      end;
   end;
end;

end.
